﻿namespace Microsoft.Samples.PlanMyNight.AddIns.Share
{
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.Infrastructure;

    public class SharingContextualActionsExport
    {
        [Export(typeof(ExtensionLink))]
        [ExtensionSiteMetadata(TargetExtensionSite = "SharingLinks")]
        public ExtensionLink ShortenUrlLink
        {
            get
            {
                return new ExtensionLink()
                {
                    LinkText = "Shorten URL",
                    RouteLink = new RouteValueDictionary(new { controller = "Sharing", action = "ShortUrl", area = RouteTableConfiguration.AreaName }),
                    Attributes = new Dictionary<string, object> {
                        { "class", "shorten" },
                        { "rel", "nofollow" },
                        { "onclick", "generateShortenUrl(this); return false" }
                    }
                };
            }
        }

        [Export(typeof(RouteValueDictionary))]
        [ExtensionSiteMetadata(TargetExtensionSite = "SharingToolbox")]
        public RouteValueDictionary ShortenUrlToolbox
        {
            get
            {
                return new RouteValueDictionary(new { controller = "Sharing", action = "ShortUrlToolbox", area = RouteTableConfiguration.AreaName });
            }
        }

        [Export(typeof(ExtensionLink))]
        [ExtensionSiteMetadata(TargetExtensionSite = "SharingLinks")]
        public ExtensionLink ShareLink
        {
            get
            {
                return new ExtensionLink()
                {
                    LinkText = "Share",
                    RouteLink = new RouteValueDictionary(new { controller = "Sharing", action = "Share", area = RouteTableConfiguration.AreaName }),
                    Attributes = new Dictionary<string, object> {
                        { "class", "share" },
                        { "rel", "nofollow" },
                        { "onclick", "$('#itineraryShare').fadeIn(); return false" }
                    }
                };
            }
        }

        [Export(typeof(RouteValueDictionary))]
        [ExtensionSiteMetadata(TargetExtensionSite = "SharingToolbox")]
        public RouteValueDictionary ShareToolbox
        {
            get
            {
                return new RouteValueDictionary(new { controller = "Sharing", action = "ShareToolbox", area = RouteTableConfiguration.AreaName });
            }
        }
    }
}